/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.minecraft.weather;

import com.mojang.blaze3d.systems.RenderSystem;
import net.diebuddies.compat.Sodium;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.math.Math;
import net.diebuddies.minecraft.weather.WeatherParticle;
import net.diebuddies.physics.StarterClient;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class SnowParticle
extends WeatherParticle {
    private static Vector3f position0 = new Vector3f(-1.0f, -1.0f, 0.0f);
    private static Vector3f position1 = new Vector3f(-1.0f, 1.0f, 0.0f);
    private static Vector3f position2 = new Vector3f(1.0f, 1.0f, 0.0f);
    private static Vector3f position3 = new Vector3f(1.0f, -1.0f, 0.0f);
    private static Vector3f tmp0 = new Vector3f();
    private static Vector3f tmp1 = new Vector3f();
    private static Vector3f tmp2 = new Vector3f();
    private static Vector3f tmp3 = new Vector3f();
    private static float oldRotX;
    private static float oldRotY;
    private static float oldRotZ;
    private static float oldRotW;

    public SnowParticle(class_638 clientLevel, double x, double y, double z, double vx, double vy, double vz) {
        super(clientLevel, x, y, z, vx, vy, vz);
        this.field_3844 = 0.002f;
        this.dampingX = 0.999;
        this.dampingY = 0.98;
        this.dampingZ = 0.999;
        this.setColor(255, 255, 255, (int)((float)(155 + (int)((double)Math.random() * 40.0)) * ConfigClient.particleSnowOpacity));
    }

    public void method_3074(class_4588 vertexConsumer, class_4184 camera, float renderPercent) {
        RenderSystem.disableCull();
        class_243 cameraPos = camera.method_19326();
        double px = org.joml.Math.lerp((double)this.field_3858, (double)this.field_3874, (double)renderPercent);
        double py = org.joml.Math.lerp((double)this.field_3838, (double)this.field_3854, (double)renderPercent);
        double pz = org.joml.Math.lerp((double)this.field_3856, (double)this.field_3871, (double)renderPercent);
        float currentX = (float)(px - cameraPos.method_10216());
        float currentY = (float)(py - cameraPos.method_10214());
        float currentZ = (float)(pz - cameraPos.method_10215());
        Quaternionf cameraRotation = camera.method_23767();
        if (oldRotX != cameraRotation.x() || oldRotY != cameraRotation.y() || oldRotZ != cameraRotation.z() || oldRotW != cameraRotation.w()) {
            float quadSize = this.getQuadSize();
            this.tmpRotation.set(cameraRotation.x(), cameraRotation.y(), cameraRotation.z(), cameraRotation.w());
            this.tmpRotation.transform(tmp0.set((Vector3fc)position0)).mul(quadSize);
            this.tmpRotation.transform(tmp1.set((Vector3fc)position1)).mul(quadSize);
            this.tmpRotation.transform(tmp2.set((Vector3fc)position2)).mul(quadSize);
            this.tmpRotation.transform(tmp3.set((Vector3fc)position3)).mul(quadSize);
            oldRotX = cameraRotation.x();
            oldRotY = cameraRotation.y();
            oldRotZ = cameraRotation.z();
            oldRotW = cameraRotation.w();
        }
        float u0 = this.getU0();
        float u1 = this.getU1();
        float v0 = this.getV0();
        float v1 = this.getV1();
        int light = this.method_3068(renderPercent);
        if (StarterClient.sodium) {
            Sodium.renderParticle(vertexConsumer, tmp0, tmp1, tmp2, tmp3, currentX, currentY, currentZ, u0, v0, u1, v1, this.argb, light);
        } else {
            vertexConsumer.method_22912(tmp0.x() + currentX, tmp0.y() + currentY, tmp0.z() + currentZ).method_22913(u1, v1).method_1336(this.r, this.g, this.b, this.a).method_60803(light);
            vertexConsumer.method_22912(tmp1.x() + currentX, tmp1.y() + currentY, tmp1.z() + currentZ).method_22913(u1, v0).method_1336(this.r, this.g, this.b, this.a).method_60803(light);
            vertexConsumer.method_22912(tmp2.x() + currentX, tmp2.y() + currentY, tmp2.z() + currentZ).method_22913(u0, v0).method_1336(this.r, this.g, this.b, this.a).method_60803(light);
            vertexConsumer.method_22912(tmp3.x() + currentX, tmp3.y() + currentY, tmp3.z() + currentZ).method_22913(u0, v1).method_1336(this.r, this.g, this.b, this.a).method_60803(light);
        }
    }

    @Override
    public class_3999 method_18122() {
        return class_3999.field_17829;
    }

    public static class Provider
    implements class_707<class_2400> {
        private final class_4002 sprite;

        public Provider(class_4002 spriteSet) {
            this.sprite = spriteSet;
        }

        public class_703 createParticle(class_2400 simpleParticleType, class_638 clientLevel, double x, double y, double z, double vx, double vy, double vz) {
            SnowParticle particle = new SnowParticle(clientLevel, x, y, z, vx, vy, vz);
            particle.pickSprite(this.sprite);
            return particle;
        }
    }
}

